<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>RetroCryptix | DVD Vault</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Press+Start+2P&display=swap');

    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      background-color: #000;
      color: #00ff88;
      font-family: 'Press Start 2P', monospace;
    }

    header {
      background: linear-gradient(180deg, #00ff88 0%, #003322 100%);
      padding: 30px 20px;
      text-align: center;
      box-shadow: 0 0 15px #00ff88;
    }

    header img {
      width: 100px;
      display: block;
      margin: 0 auto 15px;
    }

    header h1 {
      margin: 0;
      font-size: 16px;
      color: #000;
      text-shadow: 0 0 4px #00ff88;
    }

    nav {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      gap: 20px;
      background-color: #111;
      padding: 12px 0;
      border-top: 2px solid #00ff88;
      border-bottom: 2px solid #00ff88;
    }

    nav a {
      color: #00ff88;
      text-decoration: none;
      font-size: 12px;
    }

    .hero {
      padding: 40px 20px 10px;
      text-align: center;
    }

    .hero h2 {
      font-size: 14px;
      margin-bottom: 12px;
      text-shadow: 0 0 3px #00ff88;
    }

    .grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(130px, 1fr));
      gap: 20px;
      padding: 0 20px 40px;
      max-width: 1200px;
      margin: 0 auto;
    }

    .dvd {
      background-color: #111;
      border: 2px solid #00ff88;
      padding: 10px;
      text-align: center;
      box-shadow: 0 0 8px #00ff88 inset;
      border-radius: 6px;
    }

    .dvd img {
      width: 100%;
      height: auto;
      border-radius: 4px;
      box-shadow: 0 0 6px #00ff88;
    }

    .dvd-title {
      font-size: 10px;
      margin-top: 10px;
      text-shadow: 0 0 2px #00ff88;
    }

    .dvd-year {
      font-size: 8px;
      color: #99ffcc;
      margin-top: 4px;
    }

    footer {
      padding: 20px;
      text-align: center;
      font-size: 10px;
      color: #00ff88;
      background-color: #000;
      border-top: 1px dashed #00ff88;
    }

    @media (max-width: 600px) {
      header img { width: 80px; }
      nav a { font-size: 10px; }
      .hero h2 { font-size: 12px; }
    }
  </style>
</head>
<body>

  <header>
    <img src="alien-logo.png" alt="RetroCryptix Logo" />
    <h1>RETROCRYPTIX DVD VAULT</h1>
  </header>

  <nav>
    <a href="#">Home</a>
    <a href="#">Games</a>
    <a href="#">Media</a>
    <a href="#">Shop</a>
    <a href="#">Contact</a>
  </nav>

  <section class="hero">
    <h2>🎬 Explore My Personal DVD Collection</h2>
    <p style="font-size: 10px; color: #88ffcc;">Over 40+ classics and cult hits, straight from the RetroCryptix archives.</p>
  </section>

  <section class="grid">
    <div class="dvd">
      <img src="https://encrypted-tbn2.gstatic.com/images?q=tbn:ANd9GcTNMjQG47uVQIYWSHNwsVoUR3RyB3hyiF_E209yopveR8AENZLF1PMh97Ns80iVpkjzHY7m" alt="127 Hours">
      <div class="dvd-title">127 Hours</div>
      <div class="dvd-year">2010</div>
    </div>

    <div class="dvd">
      <img src="https://m.media-amazon.com/images/I/81g4RCjR-SL._UF1000,1000_QL80_.jpg" alt="2 Guns">
      <div class="dvd-title">2 Guns</div>
      <div class="dvd-year">2013</div>
    </div>

    <div class="dvd">
      <img src="https://m.media-amazon.com/images/M/MV5BZGExM2MwNjUtNThkNi00ZjBmLWJhZDgtN2ZmOWJiZWEwNGMxXkEyXkFqcGc@._V1_FMjpg_UX1000_.jpg" alt="American Gangster">
      <div class="dvd-title">American Gangster</div>
      <div class="dvd-year">2007</div>
    </div>

    <!-- Add more DVD blocks here -->
  </section>

  <footer>
    &copy; 2025 RetroCryptix. Stay retro, stay encrypted. 👽💾
  </footer>

</body>
</html>
